using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using CashierCrisis.Scenes;
using CashierCrisis.UserInterface;


namespace CashierCrisis.Managers
{
    /// <summary>
    /// This is a game component that implements IUpdateable.
    /// </summary>
    public class SceneManager : Microsoft.Xna.Framework.DrawableGameComponent
    {
        private Scene _currentScene;
        public Scene CurrentScene
        {
            get { return _currentScene; }
            set { _currentScene = value; }
        }

        private SpriteBatch spriteBatch;

        private Rectangle _screenRectangle;
        public Rectangle ScreenRectangle
        {
            get { return _screenRectangle; }
            set { _screenRectangle = value; }
        }

        public int CenterAlign
        {
            get { return _screenRectangle.Width / 2; }
        }

        public int LeftAlign
        {
            get
            {
                float left = _screenRectangle.Width * 0.2f;
                return (int)left;
            }
        }

        public int RightAlign
        {
            get
            {
                float right = _screenRectangle.Width - (_screenRectangle.Width * 0.2f);
                return (int)right;
            }
        }

        private Dictionary<string, Scene> _scenes = new Dictionary<string, Scene>();


        public SceneManager(Game game)
            : base(game)
        {
            spriteBatch = new SpriteBatch(game.GraphicsDevice);
            game.Services.AddService(typeof(SpriteBatch), spriteBatch);
            ScreenRectangle = new Rectangle(0, 0, 
                game.GraphicsDevice.Viewport.Width, 
                game.GraphicsDevice.Viewport.Height);
            DrawOrder = 25;
        }

        /// <summary>
        /// Allows the game component to perform any initialization it needs to before starting
        /// to run.  This is where it can query for any required services and load content.
        /// </summary>
        public override void Initialize()
        {
            
            base.Initialize();
        }

        /// <summary>
        /// Allows the game component to update itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        public override void Update(GameTime gameTime)
        {
            if (CurrentScene != null)
            {
                CurrentScene.Update(gameTime);
            }

            base.Update(gameTime);
        }

        public override void Draw(GameTime gameTime)
        {
            if (CurrentScene != null)
            {
                spriteBatch.Begin();
                CurrentScene.Draw(spriteBatch);
                spriteBatch.End();
            }
            base.Draw(gameTime);
        }

        public void ChangeScene(Scene scene)
        {
            if (CurrentScene != null)
            {
                CurrentScene.UnloadContent();
                EntityManager entityManager = (EntityManager)Game.Services.GetService(typeof(EntityManager));
                entityManager.Clear();
            }
            CurrentScene = scene;
            CurrentScene.LoadContent();
        }

        public void ChangeScene(string sceneName)
        {
            ChangeScene(_scenes[sceneName]);
        }

        public void AddScene(string sceneName, Scene scene)
        {
            scene.SceneManager = this;
            _scenes.Add(sceneName, scene);
        }

        public Scene GetScene(string sceneName)
        {
            return _scenes[sceneName];
        }

    }
}